/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PICheckTransCecState;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.exceptions.PISystemException;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.HscPrintStream;
import com.ibm.hsc.common.util.PIBuildCommandPacket;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.common.util.PIHscConstants;
import com.ibm.hsc.common.util.PIHscProviderSocket;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.common.util.ProviderHdwrSvrCommunication;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public abstract class PIHscProviderUtils {
    static Hashtable doFSPCommand(String string, String[] stringArray, PIHscProviderSocket pIHscProviderSocket) throws PIHscServerException {
        return PIHscProviderUtils.doFSPCommand(string, stringArray, pIHscProviderSocket, 0);
    }

    public static Hashtable doFSPCommand(String string, String[] stringArray, PIHscProviderSocket pIHscProviderSocket, int n) throws PIHscServerException {
        byte[] byArray;
        DataInputStream dataInputStream;
        DataOutputStream dataOutputStream;
        block13: {
            dataOutputStream = null;
            dataInputStream = null;
            byArray = null;
            try {
                dataOutputStream = new DataOutputStream(pIHscProviderSocket.getOutputStream());
                dataInputStream = new DataInputStream(pIHscProviderSocket.getInputStream());
                pIHscProviderSocket.setSoTimeout(n);
            }
            catch (IOException iOException) {
                if (PIHscProviderUtils.isSocketOk(pIHscProviderSocket)) break block13;
                System.err.println(" -- doFSP (1) -- Socket broken. Re-connect ...");
                String string2 = pIHscProviderSocket.getCecName();
                ProviderHdwrSvrCommunication.recreateConnection(string2);
                throw new PIHscServerException("0202", iOException);
            }
        }
        System.out.println("*********************************************************************");
        try {
            System.out.print("The command is: " + string);
            byArray = PIBuildCommandPacket.buildCommand(string, stringArray);
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildFspPassthrough(pIHscProviderSocket.getVport(), 0, byArray);
            byArray = hardwareServerMessage.toBytes();
            if (HscPrintStream.isTraceActive()) {
                System.out.println(new HexDump(byArray));
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to build the command: " + string);
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("0204", exception);
        }
        try {
            int n2 = dataInputStream.available();
            if (n2 > 0) {
                System.out.println(" Skipping " + n2 + " leftover bytes");
                dataInputStream.skipBytes(n2);
            }
        }
        catch (IOException iOException) {
            System.out.println(" Excp in reading leftover bytes.");
        }
        try {
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            System.out.println("Packet sent.");
            HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(dataInputStream);
            System.out.println("hdwr_svr response = " + hardwareServerMessage.toString());
            if (hardwareServerMessage.isHSError()) {
                throw new PISystemException(string, hardwareServerMessage);
            }
            byArray = hardwareServerMessage.getPayload();
            PIParseResponse pIParseResponse = new PIParseResponse(byArray);
            if (!pIParseResponse.isNoErrorStatusResponse()) {
                Hashtable hashtable = pIParseResponse.getErrorData();
                int n3 = (Integer)hashtable.get("ERROR_TYPE");
                if (n3 == 33006) {
                    CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get("ERROR_DATA");
                    throw new PISystemException(string, cmdExtendedErrorList);
                }
                throw new PISystemException(string, n3);
            }
            return pIParseResponse.getParsedData(string);
        }
        catch (IOException iOException) {
            HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("0204", iOException);
        }
    }

    public static boolean isSocketOk(PIHscProviderSocket pIHscProviderSocket) {
        boolean bl = true;
        if (pIHscProviderSocket == null) {
            bl = false;
        } else {
            try {
                DataInputStream dataInputStream = new DataInputStream(pIHscProviderSocket.getInputStream());
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public static String getCecNameFromSysProfileObjPath(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        String string = (String)cIMInstance.getProperty("SystemName").getValue().getValue();
        return string;
    }

    public static boolean checkPermission(Vector vector, String string) {
        return PIHmcAccessUtils.checkPermission(vector, string);
    }

    public static void validateUserDefName(String string) throws PIHscServerException {
        string = string.trim();
        int n = 32;
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        boolean bl = false;
        Vector vector = new Vector(0);
        for (int i = cArray.length - 1; i >= 0; --i) {
            n = cArray[i];
            if (n != 92 && n != 60 && n != 62 && n != 42 && n != 38 && n != 63 && n != 36 && n != 124 && n != 91 && n != 93 && n != 41 && n != 39 && n != 34 && n != 96 && n != 40 && n >= 32 && n <= 126) continue;
            throw new PIHscServerException("0236", new String[]{PIHscConstants.INVALID_CHARS}, null);
        }
    }

    public static String mapStateStr(int n) {
        System.out.println("cecState = " + n);
        String string = "";
        switch (n) {
            case 3: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_NO_POWER");
                break;
            }
            case 6: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_INITIALIZING");
                break;
            }
            case 12: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_ERROR");
                break;
            }
            case 15: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_CUOD_CTA");
                break;
            }
            case 1: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_READY");
                break;
            }
            case 13: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_ERROR_DUMP_IN_PROCESS");
                break;
            }
            case 14: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_ERROR_TERMINATED");
                break;
            }
            case 17: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_STANDBY");
                break;
            }
            case 32: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_POWEROFF_IN_PROCESS");
                break;
            }
            case 33: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_FSP_STATIC_FALLOVER_ERROR");
                break;
            }
            case 250: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_INCOMPATIBLE");
                break;
            }
            case 251: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_STATE_RECOVERY");
                break;
            }
            case 253: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_INCOMPLETE");
                break;
            }
            case 254: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_NO_CONNECTION");
                break;
            }
            case 241: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_AUTH_FAILED");
                break;
            }
            case 240: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_AUTH_FAILED");
                break;
            }
            case 242: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_AUTH_PENDING");
                break;
            }
            case 243: {
                string = HSCResourceBundleUtil.encodeNLSMsg("CECBundle", "CEC_AUTH_PENDING");
                break;
            }
        }
        return string;
    }

    public static void checkAndTransitProperState(OmCecMgr omCecMgr, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle, FspLockHelper fspLockHelper) throws PIHscServerException, CIMException {
        PICheckTransCecState pICheckTransCecState = new PICheckTransCecState();
        pICheckTransCecState.checkAndTransitProperState(omCecMgr, cIMObjectPath, providerCIMOMHandle, fspLockHelper, true);
    }

    public static void checkAndTransitProperState(OmCecMgr omCecMgr, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle, FspLockHelper fspLockHelper, boolean bl) throws PIHscServerException, CIMException {
        PICheckTransCecState pICheckTransCecState = new PICheckTransCecState();
        pICheckTransCecState.checkAndTransitProperState(omCecMgr, cIMObjectPath, providerCIMOMHandle, fspLockHelper, bl);
    }

    public static String getObjName(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = null;
        String string = null;
        Vector vector = cIMObjectPath.getKeys();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            cIMProperty = (CIMProperty)vector.elementAt(i);
            if (!cIMProperty.getName().equals("Name")) continue;
            string = (String)cIMProperty.getValue().getValue();
            break;
        }
        return string;
    }
}

